#include "CN121_API.h"


void ADC1_IRQHandler(void)
{
	HAL_ADC_IRQHandler(&hadc1);
}
void HAL_ADC_ConvCpltCallback(ADC_HandleTypeDef *hadc)
{
	int16_t adc_val_temp = (int16_t)(HAL_ADC_GetValue(&hadc1) & 0x0000ffff);
	CN121_Data_Proc(ADC_IT_PROC, &adc_val_temp);
}

void TIM2_IRQHandler(void)
{
	int16_t temp0 = 0;
	CN121_Data_Proc(TIMER_IT_PROC, &temp0);
	HAL_ADC_Start_IT(&hadc1);
	HAL_TIM_IRQHandler(&htim2);
}

/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{

	SystemClock_Config();
	ADC1_Init();
	TIM2_Init();
	GPIO_LOD_Init();
	GPIO_RST_Init();
	GPIO_SPI_Init();
	USART1_UART_Init();

	while (1)
	{	
		CN121_Parameter_Init(0,1,3.3,0.9);
		if(CN121_Init(Medical_MODE)) {/*printf(“success!\n”)*/}
		
		while(1)
		{
			CN121_Start();
			HAL_TIM_Base_Start_IT(&htim2);

			while(lod_status == LEAD_OFF)
			{
			}

			CN121_LOD_ON_Init();

			while(lod_status == LEAD_ON)
			{
				int16_t ecg;
				uint8_t result;
				if(FIFO_Size() > 0)
				{
					result = CN121_Data_Proc(GET_VALUE_PROC, &ecg);
					if(result == 0){
						printf("ecg process success! value = %d\r\n", ecg);
					}
				}
			}
		}
	}
}
