//****** CN121 SDK ******//
//*** SDK Information ***//
// Clock frequency: 80MHz
// Minimum clock frequency : 32MHz
// ADC sampling rate: 250Hz
// ADC resolution：12bit
// Power line frequency filter: 50Hz
// Optional medical standard ECG waveform
//Website: http://www.cyzur.com
//Mail: contactus@cyzur.com	
//Release Date: 2023/8/4
//Version: VB.1
//Copyright(C) CyzurTech (Shanghai) Co. Ltd. 2020-
//All rights reserved

#include  "CN121_utils.h"

TIM_HandleTypeDef htim2;
ADC_HandleTypeDef hadc1;

/**
 * @brief System Clock Configuration
 * @retval None
 */
void SystemClock_Config(void)
{
	RCC_OscInitTypeDef RCC_OscInitStruct = {0};
	RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

	/** Configure the main internal regulator output voltage
	 */
	if (HAL_PWREx_ControlVoltageScaling(PWR_REGULATOR_VOLTAGE_SCALE1) != HAL_OK)
	{
		Error_Handler();
	}

	/** Initializes the RCC Oscillators according to the specified parameters
	 * in the RCC_OscInitTypeDef structure.
	 */
	RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSE;
	RCC_OscInitStruct.HSEState = RCC_HSE_ON;
	RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
	RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSE;
	RCC_OscInitStruct.PLL.PLLM = 1;
	RCC_OscInitStruct.PLL.PLLN = 20;
	RCC_OscInitStruct.PLL.PLLP = RCC_PLLP_DIV7;
	RCC_OscInitStruct.PLL.PLLQ = RCC_PLLQ_DIV2;
	RCC_OscInitStruct.PLL.PLLR = RCC_PLLR_DIV2;
	if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
	{
		Error_Handler();
	}

	/** Initializes the CPU, AHB and APB buses clocks
	 */
	RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
			|RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
	RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
	RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
	RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;
	RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;

	if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_4) != HAL_OK)
	{
		Error_Handler();
	}
}


void CN1xx_delay_us(uint32_t udelay)
{
	uint32_t startval, tickn, delays, wait;

	startval = SysTick->VAL;
	tickn = HAL_GetTick();
	//sysc = 80000;
	delays = udelay * 80;
	if(delays > startval)
	{
		while(HAL_GetTick() == tickn)
		{

		}
		wait = 80000 + startval -delays;
		while(wait < SysTick->VAL)
		{

		}
	}
	else
	{
		wait = startval - delays;
		while(wait < SysTick->VAL && HAL_GetTick() == tickn)
		{

		}
	}
}



uint8_t CN1xx_SPI_ReadWrite(uint8_t* TxDataSeq,uint8_t* RxDataSeq,uint8_t SeqLen)
{

//	HAL_SPI_TransmitReceive(&hspi1, TxDataSeq, RxDataSeq, SeqLen, HAL_MAX_DELAY);
	uint8_t hw_spi = 0; // if use hardware spi, make sure hw_spi = 1;
	return hw_spi;
}



void TIM2_Init(void)
{

	/* USER CODE BEGIN TIM2_Init 0 */

	/* USER CODE END TIM2_Init 0 */

	TIM_ClockConfigTypeDef sClockSourceConfig = {0};
	TIM_MasterConfigTypeDef sMasterConfig = {0};

	/* USER CODE BEGIN TIM2_Init 1 */

	/* USER CODE END TIM2_Init 1 */
	htim2.Instance = TIM2;
	htim2.Init.Prescaler = 159;
	htim2.Init.CounterMode = TIM_COUNTERMODE_UP;
	htim2.Init.Period = 1999;
	htim2.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
	htim2.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_DISABLE;
	if (HAL_TIM_Base_Init(&htim2) != HAL_OK)
	{
		Error_Handler();
	}
	sClockSourceConfig.ClockSource = TIM_CLOCKSOURCE_INTERNAL;
	if (HAL_TIM_ConfigClockSource(&htim2, &sClockSourceConfig) != HAL_OK)
	{
		Error_Handler();
	}
	sMasterConfig.MasterOutputTrigger = TIM_TRGO_UPDATE;
	sMasterConfig.MasterSlaveMode = TIM_MASTERSLAVEMODE_DISABLE;
	if (HAL_TIMEx_MasterConfigSynchronization(&htim2, &sMasterConfig) != HAL_OK)
	{
		Error_Handler();
	}
	/* USER CODE BEGIN TIM2_Init 2 */

	/* USER CODE END TIM2_Init 2 */

}


/**
 * @brief ADC1 Initialization Function
 * @param None
 * @retval None
 */
void ADC1_Init(void)
{

	ADC_ChannelConfTypeDef sConfig = {0};

	hadc1.Instance = ADC1;
	hadc1.Init.ClockPrescaler = ADC_CLOCK_ASYNC_DIV1;
	hadc1.Init.Resolution = ADC_RESOLUTION_12B;
	hadc1.Init.DataAlign = ADC_DATAALIGN_RIGHT;
	hadc1.Init.ScanConvMode = ADC_SCAN_DISABLE;
	hadc1.Init.EOCSelection = ADC_EOC_SINGLE_CONV;
	hadc1.Init.LowPowerAutoWait = DISABLE;
	hadc1.Init.ContinuousConvMode = DISABLE;
	hadc1.Init.NbrOfConversion = 1;
	hadc1.Init.DiscontinuousConvMode = DISABLE;
	hadc1.Init.ExternalTrigConv = ADC_SOFTWARE_START;
	hadc1.Init.ExternalTrigConvEdge = ADC_EXTERNALTRIGCONVEDGE_NONE;
	hadc1.Init.DMAContinuousRequests = DISABLE;
	hadc1.Init.Overrun = ADC_OVR_DATA_PRESERVED;
	hadc1.Init.OversamplingMode = DISABLE;
	if (HAL_ADC_Init(&hadc1) != HAL_OK)
	{
		Error_Handler();
	}

	/** Configure Regular Channel
	 */
	sConfig.Channel = ADC_CHANNEL_5;
	sConfig.Rank = ADC_REGULAR_RANK_1;
	sConfig.SamplingTime = ADC_SAMPLETIME_24CYCLES_5;
	sConfig.SingleDiff = ADC_SINGLE_ENDED;
	sConfig.OffsetNumber = ADC_OFFSET_NONE;
	sConfig.Offset = 0;
	if (HAL_ADC_ConfigChannel(&hadc1, &sConfig) != HAL_OK)
	{
		Error_Handler();
	}
	/* USER CODE BEGIN ADC1_Init 2 */

	/* USER CODE END ADC1_Init 2 */

}


void GPIO_LOD_Init(void)
{
	GPIO_InitTypeDef  GPIO_InitStruct;
	__HAL_RCC_GPIOA_CLK_ENABLE();
	GPIO_InitStruct.Pin = DB_LOD1_Pin;
	GPIO_InitStruct.Mode = GPIO_MODE_INPUT;
	GPIO_InitStruct.Pull = GPIO_NOPULL ;
	HAL_GPIO_Init(DB_LOD1_GPIO_Port, &GPIO_InitStruct);
}

void GPIO_RST_Init(void)
{
	GPIO_InitTypeDef  GPIO_InitStructure;
	__HAL_RCC_GPIOC_CLK_ENABLE();

	GPIO_InitStructure.Pin = DB_RST_Pin;
	GPIO_InitStructure.Mode = GPIO_MODE_OUTPUT_PP;//推挽输出
	GPIO_InitStructure.Speed = GPIO_SPEED_FREQ_HIGH;
	GPIO_InitStructure.Pull = GPIO_PULLDOWN;
	HAL_GPIO_Init(DB_RST_GPIO_Port, &GPIO_InitStructure);//初始化
}

void GPIO_SPI_Init(void)
{
	GPIO_InitTypeDef  GPIO_InitStructure;

	__HAL_RCC_GPIOA_CLK_ENABLE();

	// init pin csb

	GPIO_InitStructure.Pin = DB_CSB_Pin;
	GPIO_InitStructure.Mode = GPIO_MODE_OUTPUT_PP;//推挽输出
	GPIO_InitStructure.Speed = GPIO_SPEED_FREQ_HIGH;
	GPIO_InitStructure.Pull = GPIO_PULLDOWN;
	HAL_GPIO_Init(DB_CSB_GPIO_Port, &GPIO_InitStructure);//初始化

	// init pin sclk

	GPIO_InitStructure.Pin = DB_SCLK_Pin;
	GPIO_InitStructure.Mode = GPIO_MODE_OUTPUT_PP;//推挽输出
	GPIO_InitStructure.Speed = GPIO_SPEED_FREQ_HIGH;
	GPIO_InitStructure.Pull = GPIO_PULLDOWN;
	HAL_GPIO_Init(DB_SCLK_GPIO_Port, &GPIO_InitStructure);//初始化

	// init pin mosi

	GPIO_InitStructure.Pin = DB_MOSI_Pin;
	GPIO_InitStructure.Mode = GPIO_MODE_OUTPUT_PP;//推挽输出
	GPIO_InitStructure.Speed = GPIO_SPEED_FREQ_HIGH;
	GPIO_InitStructure.Pull = GPIO_PULLDOWN;
	HAL_GPIO_Init(DB_MOSI_GPIO_Port, &GPIO_InitStructure);//初始化

	// init pin miso

	GPIO_InitStructure.Pin = DB_MISO_Pin;
	GPIO_InitStructure.Mode = GPIO_MODE_INPUT;
	GPIO_InitStructure.Speed = GPIO_SPEED_FREQ_HIGH;
	GPIO_InitStructure.Pull = GPIO_PULLDOWN;
	HAL_GPIO_Init(DB_MISO_GPIO_Port, &GPIO_InitStructure);//初始化
}






//void ADC_STOP_IT(void)
//{
//	HAL_ADC_Stop_IT(&hadc1);
//}
//
//
//void TIM_BASE_START_IT(void)
//{
//	HAL_TIM_Base_Start_IT(&htim2);
//}
//
//void TIM_BASE_STOP_IT(void)
//{
//	HAL_TIM_Base_Stop_IT(&htim2);
//}

/**
 * @brief  This function is executed in case of error occurrence.
 * @retval None
 */
void Error_Handler(void)
{
	/* USER CODE BEGIN Error_Handler_Debug */
	/* User can add his own implementation to report the HAL error return state */
	__disable_irq();
	while (1)
	{
	}
	/* USER CODE END Error_Handler_Debug */
}


uint8_t DB_LOD1_LOW(void)
{
	return (HAL_GPIO_ReadPin(DB_LOD1_GPIO_Port, DB_LOD1_Pin) == GPIO_PIN_RESET);
}
uint8_t DB_LOD1_HIGH(void)
{
	return (HAL_GPIO_ReadPin(DB_LOD1_GPIO_Port, DB_LOD1_Pin) == GPIO_PIN_SET);
}

uint8_t DB_MISO_HIGH(void)
{
	return (HAL_GPIO_ReadPin(DB_MISO_GPIO_Port, DB_MISO_Pin) == GPIO_PIN_SET);
}
uint8_t DB_MISO_LOW(void)
{
	return (HAL_GPIO_ReadPin(DB_MISO_GPIO_Port, DB_MISO_Pin) == GPIO_PIN_RESET);
}

void DB_RST_SET(void)
{
	HAL_GPIO_WritePin(DB_RST_GPIO_Port, DB_RST_Pin, GPIO_PIN_SET);
}
void DB_RST_RESET(void)
{
	HAL_GPIO_WritePin(DB_RST_GPIO_Port, DB_RST_Pin, GPIO_PIN_RESET);
}
void DB_CSB_SET(void)
{
	HAL_GPIO_WritePin(DB_CSB_GPIO_Port, DB_CSB_Pin, GPIO_PIN_SET);
}
void DB_CSB_RESET(void)	
{
	HAL_GPIO_WritePin(DB_CSB_GPIO_Port, DB_CSB_Pin, GPIO_PIN_RESET);
}
void DB_SCLK_SET(void)	
{
	HAL_GPIO_WritePin(DB_SCLK_GPIO_Port, DB_SCLK_Pin, GPIO_PIN_SET);
}
void DB_SCLK_RESET(void)	
{
	HAL_GPIO_WritePin(DB_SCLK_GPIO_Port, DB_SCLK_Pin, GPIO_PIN_RESET);
}
void DB_MOSI_SET(void)	
{	
	HAL_GPIO_WritePin(DB_MOSI_GPIO_Port, DB_MOSI_Pin, GPIO_PIN_SET);
}
void DB_MOSI_RESET(void)
{	
	HAL_GPIO_WritePin(DB_MOSI_GPIO_Port, DB_MOSI_Pin, GPIO_PIN_RESET);
}


